//	CCopyFile_Entry.h

#ifndef _H_CCopyFile_Entry
#define	_H_CCopyFile_Entry

class	CEntry;
#include "CCopyFile.h"

class	CCopyFile_Entry : public CCopyFile {
	
	public: OSErr	ICopyFile_Entry(
		CCopyFile		*parent0, 
		Ptr				myData);
		
	virtual	void	Dispose(void);

	virtual	void	LogCopyFileType(void);

	CEntry			*GetEntry(void);
	virtual	OSErr	SetFileInfo(CCT_MemFileRec *fileRecP);
	virtual	OSErr	GetFileInfo(CCT_MemFileRec *fileRecP);

	virtual	OSErr	IsFolder(Boolean *isFolderB);
	virtual	OSErr	CountFilesInFolder(ulong *numFilesL);
	virtual	OSErr	GetIndFileInFolder(ulong fileIndex, Ptr *fileDataP);

	virtual	OSErr	CreateFile(Ptr parentFolderP, CCT_MemFileRec *fileRecP);
	virtual	OSErr	Delete(void);
	virtual	void	DisposeData(void);
	
	virtual	OSErr	Open(ADFS_IOType ioType, Boolean resForkB);
	virtual	OSErr	Close(void);

	OSErr			DeTokenize(ushort	*bytesReadS);

	virtual	OSErr	Read(ulong *bytesIO, char *bufP);
	virtual	OSErr	Write(ulong *bytesIO, char *bufP);
	
	virtual	OSErr	VerifyMoveFileWithinVolume(void);
	virtual	OSErr	VerifyFreeSpace(CCT_CopyRec *copyRecP);
	virtual	OSErr	VerifyFileSize(CCopyFile *sourceP, ulong fileSizeL);
	virtual	OSErr	GetSizeSelf(CCT_CopyRec *copyRecP);

	virtual	OSErr	ScanForCopySelf(Ptr myDataP, CCopyFile **fileExistsH);
	
	virtual	OSErr	GetParentRef(Ptr *parentFolderH);
	virtual	OSErr	GetVolumeRef(Ptr *volumeH);
	virtual	OSErr	MoveFileToSelf(CCopyFile *srcFileP);

	virtual	Boolean	IsForked(void);
	virtual	Boolean	SupportsForks(void);
	virtual	OSErr	GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr	SetForkInfo(CCT_ForkInfo *forkInfoP);
	/********************************************/
	char		*i_fileSysBuf;
	ulong		i_fileSysBufMaxSize;
	ulong		i_fileSysBufCurSize;
	
	Boolean		i_eofB;
	Boolean		i_detokenizeB;
	char		*i_preDetokenBuf;
	ulong		i_preDetokenBufMaxSize;
	ulong		i_preDetokenBufCurSize;
	Boolean		i_new_lineB;

	typedef		CCopyFile		_inherited;
};

#endif